# PNASM: HOW PREDICTORS AFFECT SEARCH STRATEGIES IN NEURAL ARCHITECTURE SEARCH?

## Abstract
Predictor-based Neural Architecture Search (NAS) is an important topic since it can efficiently reduce the computational cost of evaluating candidate architectures. 
Most existing predictor-based NAS algorithms aim to design different predictors to improve the prediction performance. Unfortunately, even a promising performance predictor may suffer from the accuracy decline due to  long-term and continuous usage, thus leading to the degraded performance of the search strategy. That naturally gives rise to the following problems: how  predictors affect search strategies and how to appropriately use the predictor? 
In this paper, we take reinforcement learning (RL) based search strategy 
to study  theoretically and empirically the impact of predictors on search strategies. We first formulate  a predictor-RL-based NAS algorithm as model-based RL and analyze it with a guarantee of monotonic improvement at each trail.
Then, based on this analysis, we  propose a simple procedure of  predictor usage, named $mixed\ batch$, which contains ground-truth data and prediction data.
The proposed procedure can efficiently reduce the impact of predictor errors on search strategies with maintaining performance growth. Our algorithm, Predictor-based Neural Architecture Search with Mixed batch (PNASM), outperforms traditional NAS algorithms and prior state-of-the-art predictor-based NAS algorithms on three NAS-Bench-201 tasks.

## Requirements
The environments of this repo is similar to natsbench. You can get the version of our mainly components from requirements.txt.

## Running the code
Please use the following commands to run the model(PNASM):
```python
python ./exps/main_by_time.py --dataset cifar10 --bench_name natsbench --rand_seed -1 --time_budget 40000 --fixedk 2
python ./exps/main_by_time.py --dataset cifar100 --bench_name natsbench --rand_seed -1 --time_budget 75000 --fixedk 5
python ./exps/main_by_time.py --dataset ImageNet16-120 --bench_name natsbench --rand_seed -1 --time_budget 200000 --fixedk 2  
```

Please use the following commands to run the model(PNASM-A):
```python
python ./exps/main_by_time.py --dataset cifar10 --bench_name natsbench --rand_seed -1 --time_budget 40000 --predictor_mode adaptive
python ./exps/main_by_time.py --dataset cifar100 --bench_name natsbench --rand_seed -1 --time_budget 75000 --predictor_mode adaptive
python ./exps/main_by_time.py --dataset ImageNet16-120 --bench_name natsbench --rand_seed -1 --time_budget 200000 --predictor_mode adaptive

```
